// Function to find profile URLs from LinkedIn Recruiter search pages
// This function will be injected into the page via chrome.scripting.executeScript
function findProfileUrlsFromRecruiterSearch() {
    console.log('Starting to find URLs from LinkedIn Recruiter search page');

    // Implement a more deliberate and thorough scrolling function for Recruiter pages
    function scrollRecruiterPage() {
        return new Promise((resolve) => {
            const maxScrolls = 30; // Increase max scrolls for recruiter pages
            let scrollCount = 0;
            let lastHeight = 0;
            let sameHeightCount = 0;

            function scrollDown() {
                // Record the current height before scrolling
                const previousHeight = document.body.scrollHeight;

                // Scroll in smaller increments to give content time to load
                const currentPosition = window.pageYOffset;
                const targetPosition = currentPosition + 800; // Scroll down 800px at a time
                window.scrollTo(0, targetPosition);

                console.log(`Scroll ${scrollCount + 1}/${maxScrolls}, position: ${targetPosition}px, height: ${document.body.scrollHeight}px`);

                // Wait longer for recruiter pages to load content
                setTimeout(() => {
                    const currentHeight = document.body.scrollHeight;
                    scrollCount++;

                    // Check if we're at the bottom of the page
                    const isAtBottom = window.innerHeight + window.pageYOffset >= document.body.scrollHeight - 100;

                    // Track if the height hasn't changed
                    if (currentHeight === lastHeight) {
                        sameHeightCount++;
                    } else {
                        sameHeightCount = 0;
                        lastHeight = currentHeight;
                    }

                    // If we've scrolled enough times, hit the bottom, or height hasn't changed for several scrolls
                    if (scrollCount >= maxScrolls || isAtBottom || sameHeightCount >= 5) {
                        console.log(`Finished scrolling after ${scrollCount} scrolls. At bottom: ${isAtBottom}, Same height count: ${sameHeightCount}`);

                        // One final scroll to the very bottom to ensure everything is loaded
                        window.scrollTo(0, document.body.scrollHeight);

                        // Wait a bit more before starting to find URLs
                        setTimeout(() => {
                            window.scrollTo(0, 0); // Scroll back to top
                            resolve();
                        }, 2000);
                    } else {
                        scrollDown(); // Continue scrolling
                    }
                }, 3000); // Wait 3 seconds between scrolls to ensure content loads
            }

            // Start scrolling
            scrollDown();
        });
    }

    return new Promise(async (resolve) => {
        try {
            // First scroll to load all content
            console.log('Starting to scroll Recruiter page to load all results...');
            await scrollRecruiterPage();
            console.log('Scrolling complete, now finding Recruiter profile URLs...');

            // Then find the URLs
            const profileUrls = getRecruiterProfileUrls();
            console.log(`Found ${profileUrls.length} Recruiter profile URLs`);
            resolve(profileUrls);
        } catch (error) {
            console.error('Error while scrolling or finding URLs:', error);
            // Try to get URLs even if scrolling fails
            const profileUrls = getRecruiterProfileUrls();
            resolve(profileUrls);
        }
    });

    // Helper function to find profile URLs from Recruiter search
    function getRecruiterProfileUrls() {
        const profileLinks = [];
        const seenUrls = new Set(); // Track seen URLs to avoid duplicates

        // Process a talent profile URL to convert it to a regular LinkedIn profile URL
        function processTalentUrl(url) {
            if (!url) return null;

            // Check if it's a Recruiter profile URL
            if (url.includes('/talent/profile/')) {
                // Extract the ID from the URL
                const match = url.match(/\/talent\/profile\/([^?&#]+)/);
                if (match && match[1]) {
                    const profileId = match[1];
                    // Convert to regular LinkedIn profile URL format
                    const convertedUrl = `https://www.linkedin.com/in/${profileId}`;

                    // If we haven't seen this URL before, add it
                    if (!seenUrls.has(convertedUrl)) {
                        seenUrls.add(convertedUrl);
                        console.log(`Converted Recruiter URL to regular LinkedIn URL: ${convertedUrl}`);
                        return convertedUrl;
                    }
                }
            }

            return null;
        }

        // Method 1: Look for links with the data attributes mentioned in the example HTML
        console.log('Method 1: Searching for links with data-test-link-to-profile-link attribute');
        const profileDataLinks = document.querySelectorAll('a[data-test-link-to-profile-link="true"], a[data-live-test-link-to-profile-link="true"]');
        console.log(`Found ${profileDataLinks.length} links with data-test attributes`);

        profileDataLinks.forEach(link => {
            const href = link.getAttribute('href');
            if (href) {
                const cleanUrl = processTalentUrl(href);
                if (cleanUrl) profileLinks.push(cleanUrl);
            }
        });

        // Method 2: Find profile cards in Recruiter search
        console.log('Method 2: Searching for profile cards');
        const profileCards = document.querySelectorAll('.profile-list-item, article.profile-list-item, [data-test-paginated-list-item]');
        console.log(`Found ${profileCards.length} profile cards`);

        profileCards.forEach(card => {
            const cardProfileLinks = card.querySelectorAll('a[href*="/talent/profile/"]');
            if (cardProfileLinks.length > 0) {
                const profileLink = cardProfileLinks[0];
                const href = profileLink.getAttribute('href');
                const cleanUrl = processTalentUrl(href);
                if (cleanUrl) profileLinks.push(cleanUrl);
            }
        });

        // Method 3: Look for profile names and navigate up to find links
        console.log('Method 3: Searching for profile names');
        const fullNameElements = document.querySelectorAll('[data-test-row-lockup-full-name], [data-live-test-row-lockup-full-name]');
        console.log(`Found ${fullNameElements.length} full name elements`);

        fullNameElements.forEach(el => {
            let parentContainer = el;
            let attempts = 0;
            // Navigate up to find a parent with profile links
            while (parentContainer && attempts < 5) {
                const links = parentContainer.querySelectorAll('a');
                for (const link of links) {
                    const href = link.getAttribute('href');
                    if (href && href.includes('/talent/profile/')) {
                        const cleanUrl = processTalentUrl(href);
                        if (cleanUrl) profileLinks.push(cleanUrl);
                        break; // Found a profile link, no need to check other links
                    }
                }
                parentContainer = parentContainer.parentElement;
                attempts++;
            }
        });

        // Method 4: Direct regex finding from page HTML
        console.log('Method 4: Regex finding from page HTML');
        const pageHTML = document.documentElement.innerHTML;
        const talentProfileRegex = /https:\/\/www\.linkedin\.com\/talent\/profile\/([^?&#"']+)/g;
        let match;
        while ((match = talentProfileRegex.exec(pageHTML)) !== null) {
            if (match && match[1]) {
                const profileId = match[1];
                const convertedUrl = `https://www.linkedin.com/in/${profileId}`;
                if (!seenUrls.has(convertedUrl)) {
                    seenUrls.add(convertedUrl);
                    profileLinks.push(convertedUrl);
                }
            }
        }

        // Method 5: Find all anchor tags that might contain profile links
        console.log('Method 5: Searching all anchor tags');
        const allLinks = document.querySelectorAll('a');
        allLinks.forEach(link => {
            const href = link.getAttribute('href');
            if (href && href.includes('/talent/profile/')) {
                const cleanUrl = processTalentUrl(href);
                if (cleanUrl) profileLinks.push(cleanUrl);
            }
        });

        console.log(`Total unique profile URLs finded: ${profileLinks.length}`);
        return profileLinks;
    }
}