// Function to find profile URLs from LinkedIn search results page
// This function will be injected into the page via chrome.scripting.executeScript
function findProfileUrlsFromSearchPage() {
    // First scroll to the bottom of the page to load all results
    function scrollToBottom() {
        return new Promise(resolve => {
            console.log('Scrolling to load all results...');

            let totalHeight = 0;
            const distance = 300;
            const scrollDown = () => {
                window.scrollBy(0, distance);
                totalHeight += distance;

                // If we've scrolled far enough or hit the bottom, stop scrolling
                if (totalHeight >= document.body.scrollHeight ||
                    window.innerHeight + window.pageYOffset >= document.body.scrollHeight) {
                    window.scrollTo(0, 0); // Scroll back to top
                    console.log('Finished scrolling, loaded all results');
                    resolve();
                } else {
                    setTimeout(scrollDown, 100);
                }
            };

            scrollDown();
        });
    }

    // Define a function to find profile URLs from the DOM
    function getProfileUrls() {
        // Find all profile links in the search results
        const profileLinks = [];
        const seenUrls = new Set(); // Track seen URLs to avoid duplicates

        // Process a URL to find the clean LinkedIn profile URL
        function processUrl(url) {
            if (!url || !url.includes('/in/')) return null;

            // Convert relative URLs to absolute URLs
            let profileUrl = url;
            if (profileUrl.startsWith('/')) {
                profileUrl = 'https://www.linkedin.com' + profileUrl;
            }

            // Extract the base profile URL - handling various patterns
            let cleanUrl;

            // Pattern 1: Standard URL with parameters
            if (profileUrl.includes('?')) {
                cleanUrl = profileUrl.split('?')[0];
            }
            // Pattern 2: URL with miniProfileUrn but we can find username
            else if (profileUrl.includes('miniProfileUrn')) {
                // Extract just the username part from urls like "linkedin.com/in/username?miniProfileUrn=xyz"
                const match = profileUrl.match(/linkedin\.com\/in\/([^?\/#]+)/);
                if (match && match[1]) {
                    cleanUrl = `https://www.linkedin.com/in/${match[1]}`;
                } else {
                    return null; // Can't parse this URL
                }
            }
            // Pattern 3: Clean URL
            else {
                cleanUrl = profileUrl;
            }

            // Only return if we haven't seen this URL before
            if (!seenUrls.has(cleanUrl)) {
                seenUrls.add(cleanUrl);
                return cleanUrl;
            }

            return null;
        }

        // Targeted finding specifically looking for the class mentioned by user
        const specificLinks = document.querySelectorAll('a.sDWEFrcVubKuUVGggeBOYqLlgYgPbojOc');
        console.log('Found specific LinkedIn links:', specificLinks.length);
        specificLinks.forEach(link => {
            const href = link.getAttribute('href');
            const cleanUrl = processUrl(href);
            if (cleanUrl) profileLinks.push(cleanUrl);
        });

        // Method 1: Look for all anchor tags with '/in/' in the href
        const allLinks = document.querySelectorAll('a');
        allLinks.forEach(link => {
            const href = link.getAttribute('href');
            const cleanUrl = processUrl(href);
            if (cleanUrl) profileLinks.push(cleanUrl);
        });

        // Method 2: Find profile cards or containers
        const selectors = [
            '.search-entity-result',
            '.entity-result',
            '.reusable-search-entity-result',
            '.search-result',
            '[data-chameleon-result-urn]',
            '.kZRArQqqhjjrHYceWaFbyEGWHRZbtqjTMawKA', // Added specific class from provided HTML
            '.xAuWirHJDUTuhkfOpmJApZWziplUyPIc'       // Added specific class from provided HTML
        ];

        selectors.forEach(selector => {
            const elements = document.querySelectorAll(selector);
            console.log(`Found ${elements.length} elements with selector: ${selector}`);

            elements.forEach(element => {
                const links = element.querySelectorAll('a');
                links.forEach(link => {
                    const href = link.getAttribute('href');
                    const cleanUrl = processUrl(href);
                    if (cleanUrl) profileLinks.push(cleanUrl);
                });
            });
        });

        // Method 3: Direct search for specific class from the provided HTML
        document.querySelectorAll('.BNxZPngZfeRnDrIUbICgBZvQjRvMAUnwCHuDrmRg').forEach(container => {
            const nameLinks = container.querySelectorAll('a');
            nameLinks.forEach(link => {
                const href = link.getAttribute('href');
                const cleanUrl = processUrl(href);
                if (cleanUrl) profileLinks.push(cleanUrl);
            });
        });

        console.log('Found profile URLs:', profileLinks);
        return profileLinks;
    }

    // Execute our finding functions in sequence
    return new Promise(async (resolve) => {
        await scrollToBottom(); // First scroll to load all content
        const urls = getProfileUrls(); // Then find URLs
        resolve(urls);
    });
}